<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Atendimento24h Model
 *
 * @method \App\Model\Entity\Atendimento24h get($primaryKey, $options = [])
 * @method \App\Model\Entity\Atendimento24h newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Atendimento24h[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento24h|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Atendimento24h patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento24h[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento24h findOrCreate($search, callable $callback = null, $options = [])
 */
class Atendimento24hTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('atendimento24h');
        $this->setDisplayField('atendimento24hid');
        $this->setPrimaryKey('atendimento24hid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('codunimed')
            ->allowEmpty('codunimed');

        $validator
            ->integer('atendimento24hid')
            ->allowEmpty('atendimento24hid', 'create');

        $validator
            ->dateTime('datahora_atendimento')
            ->allowEmpty('datahora_atendimento');

        $validator
            ->scalar('paciente')
            ->maxLength('paciente', 255)
            ->allowEmpty('paciente');

        $validator
            ->scalar('codorigem')
            ->maxLength('codorigem', 90)
            ->allowEmpty('codorigem');

        $validator
            ->scalar('telefonepac_solicitante')
            ->maxLength('telefonepac_solicitante', 255)
            ->allowEmpty('telefonepac_solicitante');

        $validator
            ->scalar('endereco_solicitante')
            ->maxLength('endereco_solicitante', 255)
            ->allowEmpty('endereco_solicitante');

        $validator
            ->scalar('atendenteid')
            ->maxLength('atendenteid', 100)
            ->allowEmpty('atendenteid');

        $validator
            ->scalar('reg_crm')
            ->maxLength('reg_crm', 100)
            ->allowEmpty('reg_crm');

        $validator
            ->scalar('reg_relato')
            ->maxLength('reg_relato', 1800)
            ->allowEmpty('reg_relato');

        $validator
            ->scalar('motivo')
            ->maxLength('motivo', 800)
            ->allowEmpty('motivo');

        $validator
            ->scalar('conduta')
            ->maxLength('conduta', 255)
            ->allowEmpty('conduta');

        $validator
            ->dateTime('data_integracao')
            ->allowEmpty('data_integracao');

        return $validator;
    }
}
