<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Atendimento Model
 *
 * @method \App\Model\Entity\Atendimento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Atendimento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Atendimento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Atendimento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimento findOrCreate($search, callable $callback = null, $options = [])
 */
class AtendimentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('atendimento');
        $this->setDisplayField('atendimentoid');
        $this->setPrimaryKey('atendimentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('atendimentoid')
            ->allowEmpty('atendimentoid', 'create');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 255)
            ->allowEmpty('observacao');

        $validator
            ->boolean('historicocovid')
            ->allowEmpty('historicocovid');

        $validator
            ->scalar('contatocovid')
            ->maxLength('contatocovid', 30)
            ->allowEmpty('contatocovid');

        $validator
            ->scalar('unidadesaude')
            ->maxLength('unidadesaude', 20)
            ->allowEmpty('unidadesaude');

        $validator
            ->integer('motivo')
            ->allowEmpty('motivo');

        $validator
            ->scalar('cid')
            ->maxLength('cid', 30)
            ->allowEmpty('cid');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->integer('usuariocadastro')
            ->allowEmpty('usuariocadastro');

        $validator
            ->dateTime('datahora_atendimento')
            ->allowEmpty('datahora_atendimento');

        $validator
            ->boolean('alta')
            ->allowEmpty('alta');

        $validator
            ->boolean('obito')
            ->allowEmpty('obito');

        $validator
            ->scalar('origemligacao')
            ->maxLength('origemligacao', 255)
            ->requirePresence('origemligacao', 'create')
            ->notEmpty('origemligacao');

        $validator
            ->boolean('testecolhido')
            ->requirePresence('testecolhido', 'create')
            ->notEmpty('testecolhido');

        $validator
            ->scalar('codigoteste')
            ->maxLength('codigoteste', 50)
            ->allowEmpty('codigoteste');

        $validator
            ->boolean('covidpositivo')
            ->requirePresence('covidpositivo', 'create')
            ->notEmpty('covidpositivo');

        $validator
            ->date('datateste')
            ->allowEmpty('datateste');

        $validator
            ->date('dataatendimento')
            ->requirePresence('dataatendimento', 'create')
            ->notEmpty('dataatendimento');

        $validator
            ->scalar('direcionamento')
            ->maxLength('direcionamento', 255)
            ->allowEmpty('direcionamento');

        $validator
            ->integer('hospitalid')
            ->allowEmpty('hospitalid');

        $validator
            ->scalar('hospitalnome')
            ->maxLength('hospitalnome', 255)
            ->allowEmpty('hospitalnome');

        $validator
            ->boolean('wpp')
            ->allowEmpty('wpp');

        $validator
            ->scalar('tratamento')
            ->maxLength('tratamento', 255)
            ->allowEmpty('tratamento');

        $validator
            ->date('datatratamento')
            ->allowEmpty('datatratamento');

        $validator
            ->boolean('fimsintoma')
            ->allowEmpty('fimsintoma');

        $validator
            ->boolean('metastasepulmonar')
            ->allowEmpty('metastasepulmonar');

        $validator
            ->scalar('tumorprimario')
            ->maxLength('tumorprimario', 50)
            ->allowEmpty('tumorprimario');

        $validator
            ->scalar('usuariocadastronome')
            ->maxLength('usuariocadastronome', 255)
            ->allowEmpty('usuariocadastronome');

        $validator
            ->date('dataprimeirosintoma')
            ->allowEmpty('dataprimeirosintoma');

        return $validator;
    }
}
