<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Atendimentosintoma Model
 *
 * @method \App\Model\Entity\Atendimentosintoma get($primaryKey, $options = [])
 * @method \App\Model\Entity\Atendimentosintoma newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Atendimentosintoma[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Atendimentosintoma|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Atendimentosintoma patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimentosintoma[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Atendimentosintoma findOrCreate($search, callable $callback = null, $options = [])
 */
class AtendimentosintomaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('atendimentosintoma');
        $this->setDisplayField('atendimentosintomaid');
        $this->setPrimaryKey('atendimentosintomaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('atendimentosintomaid')
            ->allowEmpty('atendimentosintomaid', 'create');

        $validator
            ->scalar('sintoma')
            ->maxLength('sintoma', 255)
            ->requirePresence('sintoma', 'create')
            ->notEmpty('sintoma');

        $validator
            ->integer('atendimentoid')
            ->requirePresence('atendimentoid', 'create')
            ->notEmpty('atendimentoid');

        return $validator;
    }
}
