<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Auditoriaobservacao Model
 *
 * @method \App\Model\Entity\Auditoriaobservacao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Auditoriaobservacao findOrCreate($search, callable $callback = null, $options = [])
 */
class AuditoriaobservacaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('auditoriaobservacao');
        $this->setDisplayField('auditoriaobservacaoid');
        $this->setPrimaryKey('auditoriaobservacaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('auditoriaobservacaoid')
            ->allowEmpty('auditoriaobservacaoid', 'create');

        $validator
            ->integer('entradapacientesid')
            ->requirePresence('entradapacientesid', 'create')
            ->notEmpty('entradapacientesid');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 800)
            ->allowEmpty('observacao');

        $validator
            ->integer('usuarioidcadastro')
            ->requirePresence('usuarioidcadastro', 'create')
            ->notEmpty('usuarioidcadastro');

        $validator
            ->scalar('usuarionomecadastro')
            ->maxLength('usuarionomecadastro', 50)
            ->allowEmpty('usuarionomecadastro');

        return $validator;
    }
}
