<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * BeneficiarioNome Model
 *
 * @method \App\Model\Entity\BeneficiarioNome get($primaryKey, $options = [])
 * @method \App\Model\Entity\BeneficiarioNome newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\BeneficiarioNome[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\BeneficiarioNome|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\BeneficiarioNome patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\BeneficiarioNome[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\BeneficiarioNome findOrCreate($search, callable $callback = null, $options = [])
 */
class BeneficiarioNomeTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('beneficiario_nome');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('cod_beneficiario')
            ->allowEmpty('cod_beneficiario');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 100)
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        $validator
            ->scalar('cpf')
            ->maxLength('cpf', 30)
            ->requirePresence('cpf', 'create')
            ->notEmpty('cpf');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 30)
            ->allowEmpty('sexo');

        $validator
            ->integer('idade')
            ->allowEmpty('idade');

        $validator
            ->scalar('faixa_etaria')
            ->maxLength('faixa_etaria', 6)
            ->allowEmpty('faixa_etaria');

        $validator
            ->integer('unimed_carteira')
            ->allowEmpty('unimed_carteira');

        $validator
            ->scalar('cod_carteira')
            ->maxLength('cod_carteira', 255)
            ->allowEmpty('cod_carteira');

        $validator
            ->integer('dv_carteira')
            ->allowEmpty('dv_carteira');

        return $validator;
    }
}
