<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Beneficiario Model
 *
 * @method \App\Model\Entity\Beneficiario get($primaryKey, $options = [])
 * @method \App\Model\Entity\Beneficiario newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Beneficiario[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Beneficiario|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Beneficiario patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Beneficiario[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Beneficiario findOrCreate($search, callable $callback = null, $options = [])
 */
class BeneficiarioTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('beneficiario');
        $this->setDisplayField('beneficiarioid');
        $this->setPrimaryKey('beneficiarioid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('beneficiarioid')
            ->allowEmpty('beneficiarioid', 'create');

        $validator
            ->scalar('CODBENEFICIARIO')
            ->maxLength('CODBENEFICIARIO', 20)
            ->allowEmpty('CODBENEFICIARIO');

        $validator
            ->scalar('QTDCONTRATOS')
            ->maxLength('QTDCONTRATOS', 20)
            ->allowEmpty('QTDCONTRATOS');

        $validator
            ->scalar('TITULO_ABERTO_CONTRATOS_ANTIGOS')
            ->maxLength('TITULO_ABERTO_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('TITULO_ABERTO_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('PROP_TITULOS_ABERTOS_CONTRATOS_ANTIGOS')
            ->maxLength('PROP_TITULOS_ABERTOS_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('PROP_TITULOS_ABERTOS_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('PROP_TITULOS_ATRASADOS_CONTRATOS_ANTIGOS')
            ->maxLength('PROP_TITULOS_ATRASADOS_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('PROP_TITULOS_ATRASADOS_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('PROP_TITULOS_ANTECIPADOS_CONTRATOS_ANTIGOS')
            ->maxLength('PROP_TITULOS_ANTECIPADOS_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('PROP_TITULOS_ANTECIPADOS_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('PROP_TITULOS_EMDIA_CONTRATOS_ANTIGOS')
            ->maxLength('PROP_TITULOS_EMDIA_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('PROP_TITULOS_EMDIA_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('PERMANENCIA_MEDIA_CONTRATOS_ANTIGOS')
            ->maxLength('PERMANENCIA_MEDIA_CONTRATOS_ANTIGOS', 20)
            ->allowEmpty('PERMANENCIA_MEDIA_CONTRATOS_ANTIGOS');

        $validator
            ->scalar('QTD_EXCLUSAO')
            ->maxLength('QTD_EXCLUSAO', 20)
            ->allowEmpty('QTD_EXCLUSAO');

        $validator
            ->scalar('QTD_MOTIVO_EXCLUSAO_INADIMPLENCIA')
            ->maxLength('QTD_MOTIVO_EXCLUSAO_INADIMPLENCIA', 20)
            ->allowEmpty('QTD_MOTIVO_EXCLUSAO_INADIMPLENCIA');

        $validator
            ->scalar('SINISTRALIDADE_MEDIA_CONTRATO_ANTERIORES')
            ->maxLength('SINISTRALIDADE_MEDIA_CONTRATO_ANTERIORES', 20)
            ->allowEmpty('SINISTRALIDADE_MEDIA_CONTRATO_ANTERIORES');

        $validator
            ->scalar('IDADE')
            ->maxLength('IDADE', 20)
            ->allowEmpty('IDADE');

        $validator
            ->scalar('SEXO')
            ->maxLength('SEXO', 20)
            ->allowEmpty('SEXO');

        $validator
            ->scalar('PROP_TITULOS_ABERTOS_CONTRATOS_ATUAL')
            ->maxLength('PROP_TITULOS_ABERTOS_CONTRATOS_ATUAL', 20)
            ->allowEmpty('PROP_TITULOS_ABERTOS_CONTRATOS_ATUAL');

        $validator
            ->scalar('PROP_TITULOS_ATRASADOS_CONTRATOS_ATUAL')
            ->maxLength('PROP_TITULOS_ATRASADOS_CONTRATOS_ATUAL', 20)
            ->allowEmpty('PROP_TITULOS_ATRASADOS_CONTRATOS_ATUAL');

        $validator
            ->scalar('PROP_TITULOS_ANTECIPADOS_CONTRATO_ATUAL')
            ->maxLength('PROP_TITULOS_ANTECIPADOS_CONTRATO_ATUAL', 20)
            ->allowEmpty('PROP_TITULOS_ANTECIPADOS_CONTRATO_ATUAL');

        $validator
            ->scalar('PROP_TITULOS_EMDIA_CONTRATO_ATUAL')
            ->maxLength('PROP_TITULOS_EMDIA_CONTRATO_ATUAL', 20)
            ->allowEmpty('PROP_TITULOS_EMDIA_CONTRATO_ATUAL');

        $validator
            ->scalar('PERMANENCIA_CONTRATO_ATUAL')
            ->maxLength('PERMANENCIA_CONTRATO_ATUAL', 20)
            ->allowEmpty('PERMANENCIA_CONTRATO_ATUAL');

        $validator
            ->scalar('DIAS_ATRASO_CONTRATO_ATUAL')
            ->maxLength('DIAS_ATRASO_CONTRATO_ATUAL', 20)
            ->allowEmpty('DIAS_ATRASO_CONTRATO_ATUAL');

        $validator
            ->scalar('SINISTRALIDADE_CONTRATO_ATUAL')
            ->maxLength('SINISTRALIDADE_CONTRATO_ATUAL', 20)
            ->allowEmpty('SINISTRALIDADE_CONTRATO_ATUAL');

        $validator
            ->scalar('QTD_DEPENDENTES_CONTRATO_ATUAL')
            ->maxLength('QTD_DEPENDENTES_CONTRATO_ATUAL', 20)
            ->allowEmpty('QTD_DEPENDENTES_CONTRATO_ATUAL');

        $validator
            ->scalar('PRODUTO_CONTRATO_ATUAL')
            ->maxLength('PRODUTO_CONTRATO_ATUAL', 20)
            ->allowEmpty('PRODUTO_CONTRATO_ATUAL');

        $validator
            ->scalar('NEGOCIACAO_MEIRELES_CONTRATO_ANTIGO')
            ->maxLength('NEGOCIACAO_MEIRELES_CONTRATO_ANTIGO', 20)
            ->allowEmpty('NEGOCIACAO_MEIRELES_CONTRATO_ANTIGO');

        $validator
            ->scalar('NEGOCIACAO_MEIRELES_CONTRATO_ATUAL')
            ->maxLength('NEGOCIACAO_MEIRELES_CONTRATO_ATUAL', 20)
            ->allowEmpty('NEGOCIACAO_MEIRELES_CONTRATO_ATUAL');

        $validator
            ->integer('GRUPO')
            ->allowEmpty('GRUPO');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
