<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Busca Model
 *
 * @method \App\Model\Entity\Busca get($primaryKey, $options = [])
 * @method \App\Model\Entity\Busca newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Busca[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Busca|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Busca patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Busca[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Busca findOrCreate($search, callable $callback = null, $options = [])
 */
class BuscaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('busca');
        $this->setDisplayField('buscaid');
        $this->setPrimaryKey('buscaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('buscaid')
            ->allowEmpty('buscaid', 'create');

        $validator
            ->scalar('titulo')
            ->maxLength('titulo', 255)
            ->allowEmpty('titulo');

        $validator
            ->scalar('link')
            ->maxLength('link', 255)
            ->allowEmpty('link');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 50)
            ->allowEmpty('tipo');

        $validator
            ->scalar('palavras')
            ->maxLength('palavras', 255)
            ->allowEmpty('palavras');

        $validator
            ->integer('prioridade')
            ->allowEmpty('prioridade');

        return $validator;
    }
}
