<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Carteira Model
 *
 * @method \App\Model\Entity\Carteira get($primaryKey, $options = [])
 * @method \App\Model\Entity\Carteira newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Carteira[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Carteira|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Carteira patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Carteira[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Carteira findOrCreate($search, callable $callback = null, $options = [])
 */
class CarteiraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('carteira');
        $this->setDisplayField('idcarteira');
        $this->setPrimaryKey('idcarteira');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcarteira')
            ->allowEmpty('idcarteira', 'create');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 1)
            ->allowEmpty('tipo');

        $validator
            ->scalar('nm_cnae')
            ->maxLength('nm_cnae', 300)
            ->allowEmpty('nm_cnae');

        $validator
            ->scalar('cnae_fiscal')
            ->maxLength('cnae_fiscal', 50)
            ->allowEmpty('cnae_fiscal');

        $validator
            ->scalar('responsavel_financeiro')
            ->maxLength('responsavel_financeiro', 50)
            ->allowEmpty('responsavel_financeiro');

        $validator
            ->scalar('data_ativacao')
            ->maxLength('data_ativacao', 20)
            ->allowEmpty('data_ativacao');

        $validator
            ->integer('numeracao_unimed')
            ->allowEmpty('numeracao_unimed');

        $validator
            ->integer('qtd_pessoas_plano')
            ->allowEmpty('qtd_pessoas_plano');

        $validator
            ->decimal('ticket_medio')
            ->allowEmpty('ticket_medio');

        $validator
            ->scalar('razao_social')
            ->maxLength('razao_social', 255)
            ->allowEmpty('razao_social');

        $validator
            ->scalar('status')
            ->maxLength('status', 20)
            ->allowEmpty('status');

        $validator
            ->scalar('motivo')
            ->maxLength('motivo', 255)
            ->allowEmpty('motivo');

        $validator
            ->scalar('fim')
            ->maxLength('fim', 20)
            ->allowEmpty('fim');

        $validator
            ->scalar('razao_social_nova')
            ->maxLength('razao_social_nova', 300)
            ->allowEmpty('razao_social_nova');

        $validator
            ->scalar('nome_fantasia')
            ->maxLength('nome_fantasia', 255)
            ->allowEmpty('nome_fantasia');

        $validator
            ->scalar('cod_secao')
            ->maxLength('cod_secao', 10)
            ->allowEmpty('cod_secao');

        $validator
            ->scalar('nm_secao')
            ->maxLength('nm_secao', 255)
            ->allowEmpty('nm_secao');

        $validator
            ->scalar('cod_divisao')
            ->maxLength('cod_divisao', 10)
            ->allowEmpty('cod_divisao');

        $validator
            ->scalar('nm_divisao')
            ->maxLength('nm_divisao', 255)
            ->allowEmpty('nm_divisao');

        $validator
            ->scalar('cod_grupo')
            ->maxLength('cod_grupo', 10)
            ->allowEmpty('cod_grupo');

        $validator
            ->scalar('nm_grupo')
            ->maxLength('nm_grupo', 255)
            ->allowEmpty('nm_grupo');

        $validator
            ->scalar('cod_classe')
            ->maxLength('cod_classe', 10)
            ->allowEmpty('cod_classe');

        $validator
            ->scalar('nm_classe')
            ->maxLength('nm_classe', 255)
            ->allowEmpty('nm_classe');

        $validator
            ->scalar('setor')
            ->maxLength('setor', 100)
            ->allowEmpty('setor');

        $validator
            ->scalar('usuario_importacao')
            ->maxLength('usuario_importacao', 50)
            ->allowEmpty('usuario_importacao');

        $validator
            ->dateTime('data_integracao')
            ->allowEmpty('data_integracao');

        return $validator;
    }
}
