<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Carteiraconta3 Model
 *
 * @method \App\Model\Entity\Carteiraconta3 get($primaryKey, $options = [])
 * @method \App\Model\Entity\Carteiraconta3 newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Carteiraconta3[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Carteiraconta3|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Carteiraconta3 patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Carteiraconta3[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Carteiraconta3 findOrCreate($search, callable $callback = null, $options = [])
 */
class Carteiraconta3Table extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('carteiraconta3');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('carteiraconta2id')
            ->requirePresence('carteiraconta2id', 'create')
            ->notEmpty('carteiraconta2id');

        $validator
            ->integer('ano_fatura')
            ->allowEmpty('ano_fatura');

        $validator
            ->integer('mes_fatura')
            ->allowEmpty('mes_fatura');

        $validator
            ->scalar('numero_fatura')
            ->maxLength('numero_fatura', 20)
            ->allowEmpty('numero_fatura');

        $validator
            ->scalar('cod_empresa')
            ->maxLength('cod_empresa', 30)
            ->allowEmpty('cod_empresa');

        $validator
            ->scalar('nome_fantasia')
            ->maxLength('nome_fantasia', 50)
            ->allowEmpty('nome_fantasia');

        $validator
            ->scalar('cgc_empresa')
            ->maxLength('cgc_empresa', 30)
            ->allowEmpty('cgc_empresa');

        $validator
            ->date('data_vencimento')
            ->allowEmpty('data_vencimento');

        $validator
            ->decimal('valor_faturado')
            ->allowEmpty('valor_faturado');

        $validator
            ->decimal('valor_recebido')
            ->allowEmpty('valor_recebido');

        $validator
            ->date('data_recebimento')
            ->allowEmpty('data_recebimento');

        $validator
            ->scalar('cod_local_receb')
            ->maxLength('cod_local_receb', 10)
            ->allowEmpty('cod_local_receb');

        $validator
            ->scalar('desc_local_pgto')
            ->maxLength('desc_local_pgto', 50)
            ->allowEmpty('desc_local_pgto');

        $validator
            ->integer('usuarioidcadastro')
            ->allowEmpty('usuarioidcadastro');

        $validator
            ->scalar('usuarionomecadastro')
            ->maxLength('usuarionomecadastro', 50)
            ->allowEmpty('usuarionomecadastro');

        $validator
            ->dateTime('data_importacao')
            ->requirePresence('data_importacao', 'create')
            ->notEmpty('data_importacao');

        return $validator;
    }
}
