<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Carteiraconta Model
 *
 * @method \App\Model\Entity\Carteiracontum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Carteiracontum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Carteiracontum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Carteiracontum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Carteiracontum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Carteiracontum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Carteiracontum findOrCreate($search, callable $callback = null, $options = [])
 */
class CarteiracontaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('carteiraconta');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('cod_unimed')
            ->allowEmpty('cod_unimed');

        $validator
            ->integer('cod_empresa')
            ->allowEmpty('cod_empresa');

        $validator
            ->scalar('razao_social')
            ->maxLength('razao_social', 300)
            ->allowEmpty('razao_social');

        $validator
            ->scalar('cgc_empresa')
            ->maxLength('cgc_empresa', 20)
            ->allowEmpty('cgc_empresa');

        $validator
            ->scalar('incl_empresa')
            ->maxLength('incl_empresa', 20)
            ->allowEmpty('incl_empresa');

        $validator
            ->scalar('exc_empresa')
            ->maxLength('exc_empresa', 20)
            ->allowEmpty('exc_empresa');

        $validator
            ->integer('cod_contrato')
            ->allowEmpty('cod_contrato');

        $validator
            ->scalar('incl_contrato')
            ->maxLength('incl_contrato', 20)
            ->allowEmpty('incl_contrato');

        $validator
            ->scalar('exc_contrato')
            ->maxLength('exc_contrato', 20)
            ->allowEmpty('exc_contrato');

        $validator
            ->scalar('status_contrato')
            ->maxLength('status_contrato', 20)
            ->allowEmpty('status_contrato');

        $validator
            ->scalar('desc_motivo_benef')
            ->maxLength('desc_motivo_benef', 200)
            ->allowEmpty('desc_motivo_benef');

        $validator
            ->integer('qtde_vidas_contrato')
            ->allowEmpty('qtde_vidas_contrato');

        $validator
            ->integer('num_fatura')
            ->allowEmpty('num_fatura');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->scalar('situacao_pgto')
            ->maxLength('situacao_pgto', 20)
            ->allowEmpty('situacao_pgto');

        $validator
            ->date('data_vencimento')
            ->allowEmpty('data_vencimento');

        $validator
            ->date('ult_data_recebimento')
            ->allowEmpty('ult_data_recebimento');

        $validator
            ->decimal('valor_recebido')
            ->allowEmpty('valor_recebido');

        $validator
            ->date('periodo_faturamento')
            ->allowEmpty('periodo_faturamento');

        return $validator;
    }
}
