<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Carteirapagamento Model
 *
 * @method \App\Model\Entity\Carteirapagamento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Carteirapagamento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Carteirapagamento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapagamento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Carteirapagamento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapagamento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapagamento findOrCreate($search, callable $callback = null, $options = [])
 */
class CarteirapagamentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('carteirapagamento');
        $this->setDisplayField('idcarteirapagamento');
        $this->setPrimaryKey('idcarteirapagamento');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcarteirapagamento')
            ->allowEmpty('idcarteirapagamento', 'create');

        $validator
            ->scalar('responsavel_financeiro')
            ->maxLength('responsavel_financeiro', 50)
            ->allowEmpty('responsavel_financeiro');

        $validator
            ->date('data_vencimento')
            ->allowEmpty('data_vencimento');

        $validator
            ->date('data_pagamento')
            ->allowEmpty('data_pagamento');

        $validator
            ->integer('mes')
            ->allowEmpty('mes');

        $validator
            ->integer('ano')
            ->allowEmpty('ano');

        $validator
            ->dateTime('data_integracao')
            ->allowEmpty('data_integracao');

        return $validator;
    }
}
