<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Carteirapj Model
 *
 * @method \App\Model\Entity\Carteirapj get($primaryKey, $options = [])
 * @method \App\Model\Entity\Carteirapj newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Carteirapj[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapj|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Carteirapj patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapj[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Carteirapj findOrCreate($search, callable $callback = null, $options = [])
 */
class CarteirapjTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('carteirapj');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 255)
            ->requirePresence('cnpj', 'create')
            ->notEmpty('cnpj');

        $validator
            ->scalar('cod_unimed')
            ->maxLength('cod_unimed', 255)
            ->requirePresence('cod_unimed', 'create')
            ->notEmpty('cod_unimed');

        $validator
            ->scalar('cod_empresa')
            ->maxLength('cod_empresa', 255)
            ->requirePresence('cod_empresa', 'create')
            ->notEmpty('cod_empresa');

        $validator
            ->scalar('razao_social')
            ->maxLength('razao_social', 255)
            ->requirePresence('razao_social', 'create')
            ->notEmpty('razao_social');

        $validator
            ->scalar('incl_empresa')
            ->maxLength('incl_empresa', 255)
            ->requirePresence('incl_empresa', 'create')
            ->notEmpty('incl_empresa');

        $validator
            ->scalar('excl_empresa')
            ->maxLength('excl_empresa', 255)
            ->requirePresence('excl_empresa', 'create')
            ->notEmpty('excl_empresa');

        $validator
            ->scalar('cod_contrato')
            ->maxLength('cod_contrato', 255)
            ->requirePresence('cod_contrato', 'create')
            ->notEmpty('cod_contrato');

        $validator
            ->scalar('incl_contrato')
            ->maxLength('incl_contrato', 255)
            ->requirePresence('incl_contrato', 'create')
            ->notEmpty('incl_contrato');

        $validator
            ->scalar('excl_contrato')
            ->maxLength('excl_contrato', 255)
            ->requirePresence('excl_contrato', 'create')
            ->notEmpty('excl_contrato');

        $validator
            ->scalar('status_contrato')
            ->maxLength('status_contrato', 255)
            ->requirePresence('status_contrato', 'create')
            ->notEmpty('status_contrato');

        $validator
            ->scalar('desc_motivo_benef')
            ->maxLength('desc_motivo_benef', 255)
            ->requirePresence('desc_motivo_benef', 'create')
            ->notEmpty('desc_motivo_benef');

        $validator
            ->integer('qtde_vidas_contrato')
            ->requirePresence('qtde_vidas_contrato', 'create')
            ->notEmpty('qtde_vidas_contrato');

        $validator
            ->scalar('numero_fatura')
            ->maxLength('numero_fatura', 255)
            ->requirePresence('numero_fatura', 'create')
            ->notEmpty('numero_fatura');

        $validator
            ->decimal('valor')
            ->requirePresence('valor', 'create')
            ->notEmpty('valor');

        $validator
            ->scalar('situacao_pgto')
            ->maxLength('situacao_pgto', 255)
            ->requirePresence('situacao_pgto', 'create')
            ->notEmpty('situacao_pgto');

        $validator
            ->date('data_vencimento')
            ->requirePresence('data_vencimento', 'create')
            ->notEmpty('data_vencimento');

        $validator
            ->date('ult_data_recebimento')
            ->requirePresence('ult_data_recebimento', 'create')
            ->notEmpty('ult_data_recebimento');

        $validator
            ->decimal('valor_recebido')
            ->requirePresence('valor_recebido', 'create')
            ->notEmpty('valor_recebido');

        $validator
            ->date('periodo_faturamento')
            ->requirePresence('periodo_faturamento', 'create')
            ->notEmpty('periodo_faturamento');

        $validator
            ->scalar('v1')
            ->maxLength('v1', 255)
            ->requirePresence('v1', 'create')
            ->notEmpty('v1');

        $validator
            ->scalar('razao_social2')
            ->maxLength('razao_social2', 255)
            ->requirePresence('razao_social2', 'create')
            ->notEmpty('razao_social2');

        $validator
            ->scalar('nome_fantasia')
            ->maxLength('nome_fantasia', 255)
            ->requirePresence('nome_fantasia', 'create')
            ->notEmpty('nome_fantasia');

        $validator
            ->scalar('cnae_fiscal')
            ->maxLength('cnae_fiscal', 255)
            ->requirePresence('cnae_fiscal', 'create')
            ->notEmpty('cnae_fiscal');

        return $validator;
    }
}
