<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Centrocusto Model
 *
 * @method \App\Model\Entity\Centrocusto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Centrocusto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Centrocusto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Centrocusto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Centrocusto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Centrocusto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Centrocusto findOrCreate($search, callable $callback = null, $options = [])
 */
class CentrocustoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('centrocusto');
        $this->setDisplayField('centrocustoid');
        $this->setPrimaryKey('centrocustoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('centrocustoid')
            ->allowEmpty('centrocustoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 60)
            ->allowEmpty('tipo');

        $validator
            ->scalar('ordem')
            ->maxLength('ordem', 20)
            ->allowEmpty('ordem');

        $validator
            ->dateTime('dataoperacao')
            ->allowEmpty('dataoperacao');

        $validator
            ->integer('usuariooperacao')
            ->allowEmpty('usuariooperacao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('planocontaid')
            ->allowEmpty('planocontaid');

        return $validator;
    }
}
