<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chamado Model
 *
 * @method \App\Model\Entity\Chamado get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chamado newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chamado[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chamado|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chamado patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chamado[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chamado findOrCreate($search, callable $callback = null, $options = [])
 */
class ChamadoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chamado');
        $this->setDisplayField('idchamado');
        $this->setPrimaryKey('idchamado');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idchamado')
            ->allowEmpty('idchamado', 'create');

        $validator
            ->integer('idchamadopai')
            ->allowEmpty('idchamadopai');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->scalar('solicitante')
            ->maxLength('solicitante', 255)
            ->allowEmpty('solicitante');

        $validator
            ->integer('idusuario_criacao')
            ->allowEmpty('idusuario_criacao');

        $validator
            ->integer('idusuario_atendimento')
            ->allowEmpty('idusuario_atendimento');

        $validator
            ->scalar('assunto')
            ->maxLength('assunto', 255)
            ->allowEmpty('assunto');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 8000)
            ->allowEmpty('descricao');

        $validator
            ->scalar('justificativa')
            ->maxLength('justificativa', 8000)
            ->allowEmpty('justificativa');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 255)
            ->allowEmpty('tipo');

        $validator
            ->scalar('status')
            ->maxLength('status', 255)
            ->allowEmpty('status');

        $validator
            ->scalar('complexidade')
            ->maxLength('complexidade', 255)
            ->allowEmpty('complexidade');

        $validator
            ->scalar('prioridade')
            ->maxLength('prioridade', 255)
            ->allowEmpty('prioridade');

        $validator
            ->integer('percentual')
            ->allowEmpty('percentual');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->date('data_prevista')
            ->allowEmpty('data_prevista');

        $validator
            ->dateTime('data_fechamento')
            ->allowEmpty('data_fechamento');

        $validator
            ->integer('idprojeto')
            ->allowEmpty('idprojeto');

        $validator
            ->integer('idproduto')
            ->allowEmpty('idproduto');

        $validator
            ->decimal('horasprevistas')
            ->allowEmpty('horasprevistas');

        $validator
            ->integer('idchamadostatus')
            ->allowEmpty('idchamadostatus');

        return $validator;
    }
}
