<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chamadolog Model
 *
 * @method \App\Model\Entity\Chamadolog get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chamadolog newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chamadolog[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chamadolog|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chamadolog patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadolog[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadolog findOrCreate($search, callable $callback = null, $options = [])
 */
class ChamadologTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chamadolog');
        $this->setDisplayField('idchamadolog');
        $this->setPrimaryKey('idchamadolog');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idchamadolog')
            ->allowEmpty('idchamadolog', 'create');

        $validator
            ->integer('idchamado')
            ->allowEmpty('idchamado');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->integer('idchamadostatus')
            ->allowEmpty('idchamadostatus');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
