<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chamadoobs Model
 *
 * @method \App\Model\Entity\Chamadoob get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chamadoob newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chamadoob[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chamadoob|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chamadoob patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadoob[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadoob findOrCreate($search, callable $callback = null, $options = [])
 */
class ChamadoobsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chamadoobs');
        $this->setDisplayField('idchamadoobs');
        $this->setPrimaryKey('idchamadoobs');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idchamadoobs')
            ->allowEmpty('idchamadoobs', 'create');

        $validator
            ->integer('idchamado')
            ->allowEmpty('idchamado');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 8000)
            ->allowEmpty('observacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('arquivo')
            ->maxLength('arquivo', 255)
            ->allowEmpty('arquivo');

        $validator
            ->integer('log')
            ->allowEmpty('log');

        $validator
            ->decimal('horastrabalhadas')
            ->allowEmpty('horastrabalhadas');

        $validator
            ->integer('idchamadostatus')
            ->allowEmpty('idchamadostatus');

        return $validator;
    }
}
