<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chamadostatus Model
 *
 * @method \App\Model\Entity\Chamadostatus get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chamadostatus newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Chamadostatus[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chamadostatus|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chamadostatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadostatus[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chamadostatus findOrCreate($search, callable $callback = null, $options = [])
 */
class ChamadostatusTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('chamadostatus');
        $this->setDisplayField('idchamadostatus');
        $this->setPrimaryKey('idchamadostatus');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idchamadostatus')
            ->allowEmpty('idchamadostatus', 'create');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        return $validator;
    }
}
