<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cid10 Model
 *
 * @method \App\Model\Entity\Cid10 get($primaryKey, $options = [])
 * @method \App\Model\Entity\Cid10 newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Cid10[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cid10|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cid10 patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Cid10[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cid10 findOrCreate($search, callable $callback = null, $options = [])
 */
class Cid10Table extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('cid10');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('codigo')
            ->maxLength('codigo', 20)
            ->allowEmpty('codigo');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 80)
            ->allowEmpty('nome');

        return $validator;
    }
}
