<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cliente Model
 *
 * @method \App\Model\Entity\Cliente get($primaryKey, $options = [])
 * @method \App\Model\Entity\Cliente newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Cliente[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cliente|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cliente patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Cliente[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cliente findOrCreate($search, callable $callback = null, $options = [])
 */
class ClienteTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('cliente');
        $this->setDisplayField('clienteid');
        $this->setPrimaryKey('clienteid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('clienteid')
            ->allowEmpty('clienteid', 'create');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->scalar('tipocliente')
            ->maxLength('tipocliente', 255)
            ->allowEmpty('tipocliente');

        $validator
            ->scalar('origemlead')
            ->maxLength('origemlead', 255)
            ->allowEmpty('origemlead');

        $validator
            ->integer('dependentes')
            ->allowEmpty('dependentes');

        $validator
            ->scalar('tipolead')
            ->maxLength('tipolead', 255)
            ->allowEmpty('tipolead');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->dateTime('data_cliente')
            ->allowEmpty('data_cliente');

        $validator
            ->integer('vendedorid')
            ->allowEmpty('vendedorid');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->scalar('coderp')
            ->maxLength('coderp', 20)
            ->allowEmpty('coderp');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 500)
            ->allowEmpty('observacao');

        $validator
            ->scalar('categoria')
            ->maxLength('categoria', 70)
            ->allowEmpty('categoria');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 300)
            ->allowEmpty('nome');

        return $validator;
    }
}
