<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CnaeDados Model
 *
 * @method \App\Model\Entity\CnaeDado get($primaryKey, $options = [])
 * @method \App\Model\Entity\CnaeDado newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\CnaeDado[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CnaeDado|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CnaeDado patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CnaeDado[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\CnaeDado findOrCreate($search, callable $callback = null, $options = [])
 */
class CnaeDadosTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('cnae_dados');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('id')
            ->maxLength('id', 10)
            ->allowEmpty('id');

        $validator
            ->scalar('cod_secao')
            ->maxLength('cod_secao', 20)
            ->allowEmpty('cod_secao');

        $validator
            ->scalar('nm_secao')
            ->maxLength('nm_secao', 300)
            ->allowEmpty('nm_secao');

        $validator
            ->scalar('cod_divisao')
            ->maxLength('cod_divisao', 300)
            ->allowEmpty('cod_divisao');

        $validator
            ->scalar('nm_divisao')
            ->maxLength('nm_divisao', 300)
            ->allowEmpty('nm_divisao');

        $validator
            ->scalar('cod_grupo')
            ->maxLength('cod_grupo', 20)
            ->allowEmpty('cod_grupo');

        $validator
            ->scalar('nm_grupo')
            ->maxLength('nm_grupo', 300)
            ->allowEmpty('nm_grupo');

        $validator
            ->scalar('cod_classe')
            ->maxLength('cod_classe', 300)
            ->allowEmpty('cod_classe');

        $validator
            ->scalar('nm_classe')
            ->maxLength('nm_classe', 300)
            ->allowEmpty('nm_classe');

        $validator
            ->scalar('cod_cnae')
            ->maxLength('cod_cnae', 20)
            ->allowEmpty('cod_cnae');

        $validator
            ->scalar('nm_cnae')
            ->maxLength('nm_cnae', 300)
            ->allowEmpty('nm_cnae');

        return $validator;
    }
}
