<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Colaborador Model
 *
 * @method \App\Model\Entity\Colaborador get($primaryKey, $options = [])
 * @method \App\Model\Entity\Colaborador newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Colaborador[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Colaborador|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Colaborador patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Colaborador[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Colaborador findOrCreate($search, callable $callback = null, $options = [])
 */
class ColaboradorTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('colaborador');
        $this->setDisplayField('colaboradorid');
        $this->setPrimaryKey('colaboradorid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('colaboradorid')
            ->allowEmpty('colaboradorid', 'create');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->integer('clienteidreferenciado')
            ->allowEmpty('clienteidreferenciado');

        $validator
            ->scalar('tipocolaborador')
            ->maxLength('tipocolaborador', 255)
            ->allowEmpty('tipocolaborador');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->scalar('hobby')
            ->maxLength('hobby', 255)
            ->allowEmpty('hobby');

        $validator
            ->scalar('observacoes')
            ->maxLength('observacoes', 500)
            ->allowEmpty('observacoes');

        return $validator;
    }
}
