<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CompraPag Model
 *
 * @method \App\Model\Entity\CompraPag get($primaryKey, $options = [])
 * @method \App\Model\Entity\CompraPag newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\CompraPag[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CompraPag|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CompraPag patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CompraPag[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\CompraPag findOrCreate($search, callable $callback = null, $options = [])
 */
class CompraPagTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('compra_pag');
        $this->setDisplayField('idcomprapag');
        $this->setPrimaryKey('idcomprapag');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcomprapag')
            ->allowEmpty('idcomprapag', 'create');

        $validator
            ->integer('idcompra')
            ->allowEmpty('idcompra');

        $validator
            ->integer('idformapagcondpag')
            ->allowEmpty('idformapagcondpag');

        $validator
            ->integer('qtdparcelas')
            ->allowEmpty('qtdparcelas');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->date('data_vencimento')
            ->allowEmpty('data_vencimento');

        return $validator;
    }
}
