<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CompraProduto Model
 *
 * @method \App\Model\Entity\CompraProduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\CompraProduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\CompraProduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CompraProduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CompraProduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CompraProduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\CompraProduto findOrCreate($search, callable $callback = null, $options = [])
 */
class CompraProdutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('compra_produto');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('idcompra')
            ->allowEmpty('idcompra');

        $validator
            ->integer('idproduto')
            ->allowEmpty('idproduto');

        $validator
            ->integer('qtd')
            ->allowEmpty('qtd');

        $validator
            ->decimal('valorprodunitario')
            ->allowEmpty('valorprodunitario');

        $validator
            ->decimal('valorprodbruto')
            ->allowEmpty('valorprodbruto');

        $validator
            ->decimal('valorprodliquido')
            ->allowEmpty('valorprodliquido');

        $validator
            ->decimal('descontoprodvalor')
            ->allowEmpty('descontoprodvalor');

        $validator
            ->decimal('descontoprodperc')
            ->allowEmpty('descontoprodperc');

        return $validator;
    }
}
