<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Compra Model
 *
 * @method \App\Model\Entity\Compra get($primaryKey, $options = [])
 * @method \App\Model\Entity\Compra newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Compra[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Compra|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Compra patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Compra[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Compra findOrCreate($search, callable $callback = null, $options = [])
 */
class CompraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('compra');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('idpessoa')
            ->allowEmpty('idpessoa');

        $validator
            ->integer('idcontato')
            ->allowEmpty('idcontato');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->decimal('totalbruto')
            ->allowEmpty('totalbruto');

        $validator
            ->decimal('totalliquido')
            ->allowEmpty('totalliquido');

        $validator
            ->date('datavalidade')
            ->allowEmpty('datavalidade');

        $validator
            ->integer('status')
            ->allowEmpty('status');

        $validator
            ->decimal('descontototalvalor')
            ->allowEmpty('descontototalvalor');

        $validator
            ->decimal('descontototalperc')
            ->allowEmpty('descontototalperc');

        $validator
            ->dateTime('datacadastro')
            ->allowEmpty('datacadastro');

        $validator
            ->integer('idpessoacadastro')
            ->allowEmpty('idpessoacadastro');

        $validator
            ->dateTime('dataaprovacao')
            ->allowEmpty('dataaprovacao');

        $validator
            ->dateTime('datacancelado')
            ->allowEmpty('datacancelado');

        $validator
            ->dateTime('datamodificacao')
            ->allowEmpty('datamodificacao');

        $validator
            ->integer('idpessoamodificacao')
            ->allowEmpty('idpessoamodificacao');

        return $validator;
    }
}
