<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Condpag Model
 *
 * @property \App\Model\Table\FormapagTable|\Cake\ORM\Association\BelongsToMany $Formapag
 *
 * @method \App\Model\Entity\Condpag get($primaryKey, $options = [])
 * @method \App\Model\Entity\Condpag newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Condpag[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Condpag|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Condpag patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Condpag[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Condpag findOrCreate($search, callable $callback = null, $options = [])
 */
class CondpagTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('condpag');
        $this->setDisplayField('idcondpag');
        $this->setPrimaryKey('idcondpag');

        $this->belongsToMany('Formapag', [
            'foreignKey' => 'condpag_id',
            'targetForeignKey' => 'formapag_id',
            'joinTable' => 'formapag_condpag'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcondpag')
            ->allowEmpty('idcondpag', 'create');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('qtdparcelas')
            ->allowEmpty('qtdparcelas');

        $validator
            ->integer('diasprimeiras')
            ->allowEmpty('diasprimeiras');

        $validator
            ->integer('diasproximas')
            ->requirePresence('diasproximas', 'create')
            ->notEmpty('diasproximas');

        return $validator;
    }
}
