<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Consulta Model
 *
 * @method \App\Model\Entity\Consultum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Consultum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Consultum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Consultum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Consultum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Consultum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Consultum findOrCreate($search, callable $callback = null, $options = [])
 */
class ConsultaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('consulta');
        $this->setDisplayField('consultaid');
        $this->setPrimaryKey('consultaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('consultaid')
            ->allowEmpty('consultaid', 'create');

        $validator
            ->scalar('arquivo')
            ->maxLength('arquivo', 100)
            ->allowEmpty('arquivo');

        $validator
            ->scalar('consulta')
            ->maxLength('consulta', 10000)
            ->allowEmpty('consulta');

        $validator
            ->scalar('parametros')
            ->maxLength('parametros', 500)
            ->allowEmpty('parametros');

        $validator
            ->scalar('resultado')
            ->maxLength('resultado', 16777215)
            ->allowEmpty('resultado');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->dateTime('data_atualizacao')
            ->allowEmpty('data_atualizacao');

        $validator
            ->allowEmpty('contador');

        $validator
            ->integer('prioridade')
            ->allowEmpty('prioridade');

        return $validator;
    }
}
