<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Conta Model
 *
 * @method \App\Model\Entity\Contum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contum findOrCreate($search, callable $callback = null, $options = [])
 */
class ContaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('conta');
        $this->setDisplayField('contaid');
        $this->setPrimaryKey('contaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contaid')
            ->allowEmpty('contaid', 'create');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->date('data_vencimento')
            ->allowEmpty('data_vencimento');

        $validator
            ->dateTime('data_competencia')
            ->allowEmpty('data_competencia');

        $validator
            ->dateTime('data_pagamento')
            ->allowEmpty('data_pagamento');

        $validator
            ->dateTime('data_cancelamento')
            ->allowEmpty('data_cancelamento');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('tipocontaid')
            ->allowEmpty('tipocontaid');

        $validator
            ->integer('subtipocontaid')
            ->allowEmpty('subtipocontaid');

        $validator
            ->numeric('totalbruto')
            ->allowEmpty('totalbruto');

        $validator
            ->numeric('totalliquido')
            ->allowEmpty('totalliquido');

        $validator
            ->integer('recorrente')
            ->allowEmpty('recorrente');

        $validator
            ->integer('codmovrecorrente')
            ->allowEmpty('codmovrecorrente');

        $validator
            ->numeric('valorparcela')
            ->allowEmpty('valorparcela');

        $validator
            ->numeric('valordescparcela')
            ->allowEmpty('valordescparcela');

        $validator
            ->numeric('percdescparcela')
            ->allowEmpty('percdescparcela');

        $validator
            ->integer('parcela')
            ->allowEmpty('parcela');

        $validator
            ->numeric('valordesc')
            ->allowEmpty('valordesc');

        $validator
            ->decimal('percdesc')
            ->allowEmpty('percdesc');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->integer('clienteid')
            ->allowEmpty('clienteid');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('categoriaid')
            ->allowEmpty('categoriaid');

        $validator
            ->scalar('status')
            ->maxLength('status', 20)
            ->allowEmpty('status');

        $validator
            ->integer('centrocustoid')
            ->allowEmpty('centrocustoid');

        $validator
            ->integer('planocontaid')
            ->allowEmpty('planocontaid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('pessoaidcancelamento')
            ->allowEmpty('pessoaidcancelamento');

        $validator
            ->integer('contarecorrente')
            ->allowEmpty('contarecorrente');

        $validator
            ->integer('codmov')
            ->allowEmpty('codmov');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 1000)
            ->allowEmpty('observacao');

        $validator
            ->integer('formapagid')
            ->allowEmpty('formapagid');

        $validator
            ->integer('condpagid')
            ->allowEmpty('condpagid');

        $validator
            ->integer('idcompra')
            ->allowEmpty('idcompra');

        $validator
            ->numeric('valorcompra')
            ->allowEmpty('valorcompra');

        return $validator;
    }
}
