<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contaanexo Model
 *
 * @method \App\Model\Entity\Contaanexo get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contaanexo newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contaanexo[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contaanexo|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contaanexo patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contaanexo[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contaanexo findOrCreate($search, callable $callback = null, $options = [])
 */
class ContaanexoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contaanexo');
        $this->setDisplayField('contaanexoid');
        $this->setPrimaryKey('contaanexoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contaanexoid')
            ->allowEmpty('contaanexoid', 'create');

        $validator
            ->integer('contaid')
            ->allowEmpty('contaid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->scalar('caminho')
            ->maxLength('caminho', 500)
            ->requirePresence('caminho', 'create')
            ->notEmpty('caminho');

        return $validator;
    }
}
