<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contabaixa Model
 *
 * @method \App\Model\Entity\Contabaixa get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contabaixa newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contabaixa[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contabaixa|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contabaixa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contabaixa[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contabaixa findOrCreate($search, callable $callback = null, $options = [])
 */
class ContabaixaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contabaixa');
        $this->setDisplayField('contabaixaid');
        $this->setPrimaryKey('contabaixaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contabaixaid')
            ->allowEmpty('contabaixaid', 'create');

        $validator
            ->integer('contaid')
            ->allowEmpty('contaid');

        $validator
            ->integer('contabancoid')
            ->allowEmpty('contabancoid');

        $validator
            ->integer('formapagid')
            ->allowEmpty('formapagid');

        $validator
            ->integer('condpagid')
            ->allowEmpty('condpagid');

        $validator
            ->numeric('valorpago')
            ->requirePresence('valorpago', 'create')
            ->notEmpty('valorpago');

        $validator
            ->numeric('juros')
            ->allowEmpty('juros');

        $validator
            ->numeric('desconto')
            ->allowEmpty('desconto');

        $validator
            ->date('data_baixa')
            ->allowEmpty('data_baixa');

        $validator
            ->dateTime('data_operacao')
            ->requirePresence('data_operacao', 'create')
            ->notEmpty('data_operacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
