<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contabanco Model
 *
 * @method \App\Model\Entity\Contabanco get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contabanco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contabanco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contabanco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contabanco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contabanco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contabanco findOrCreate($search, callable $callback = null, $options = [])
 */
class ContabancoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contabanco');
        $this->setDisplayField('contabancoid');
        $this->setPrimaryKey('contabancoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contabancoid')
            ->allowEmpty('contabancoid', 'create');

        $validator
            ->integer('bancoid')
            ->allowEmpty('bancoid');

        $validator
            ->scalar('moeda')
            ->maxLength('moeda', 11)
            ->allowEmpty('moeda');

        $validator
            ->scalar('tipoconta')
            ->maxLength('tipoconta', 255)
            ->allowEmpty('tipoconta');

        $validator
            ->scalar('codagencia')
            ->maxLength('codagencia', 15)
            ->allowEmpty('codagencia');

        $validator
            ->scalar('digagencia')
            ->maxLength('digagencia', 4)
            ->allowEmpty('digagencia');

        $validator
            ->scalar('numeroconta')
            ->maxLength('numeroconta', 15)
            ->allowEmpty('numeroconta');

        $validator
            ->integer('dignumeroconta')
            ->allowEmpty('dignumeroconta');

        $validator
            ->decimal('saldoanterior')
            ->allowEmpty('saldoanterior');

        $validator
            ->decimal('saldoatual')
            ->allowEmpty('saldoatual');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->dateTime('saldoatual_data')
            ->allowEmpty('saldoatual_data');

        $validator
            ->dateTime('saldoanterior_data')
            ->allowEmpty('saldoanterior_data');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
