<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contabx Model
 *
 * @method \App\Model\Entity\Contabx get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contabx newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contabx[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contabx|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contabx|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contabx patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contabx[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contabx findOrCreate($search, callable $callback = null, $options = [])
 */
class ContabxTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contabx');
        $this->setDisplayField('contabxid');
        $this->setPrimaryKey('contabxid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contabxid')
            ->allowEmpty('contabxid', 'create');

        $validator
            ->integer('contaid')
            ->allowEmpty('contaid');

        $validator
            ->scalar('formapag')
            ->maxLength('formapag', 20)
            ->allowEmpty('formapag');

        $validator
            ->scalar('condpag')
            ->maxLength('condpag', 20)
            ->allowEmpty('condpag');

        $validator
            ->scalar('numdoc')
            ->maxLength('numdoc', 60)
            ->allowEmpty('numdoc');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 800)
            ->allowEmpty('observacao');

        $validator
            ->numeric('valor')
            ->allowEmpty('valor');

        $validator
            ->date('databaixa')
            ->allowEmpty('databaixa');

        $validator
            ->dateTime('dataoperacao')
            ->allowEmpty('dataoperacao');

        $validator
            ->integer('usuariooperacao')
            ->allowEmpty('usuariooperacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('contabancoid')
            ->requirePresence('contabancoid', 'create')
            ->notEmpty('contabancoid');

        return $validator;
    }
}
