<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contato Model
 *
 * @method \App\Model\Entity\Contato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contato findOrCreate($search, callable $callback = null, $options = [])
 */
class ContatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contato');
        $this->setDisplayField('contatoid');
        $this->setPrimaryKey('contatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid', 'create');

        $validator
            ->integer('contatoidpai')
            ->allowEmpty('contatoidpai');

        $validator
            ->integer('clienteid')
            ->allowEmpty('clienteid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->scalar('tipocontato')
            ->maxLength('tipocontato', 255)
            ->allowEmpty('tipocontato');

        $validator
            ->scalar('statuscontrato')
            ->maxLength('statuscontrato', 255)
            ->allowEmpty('statuscontrato');

        $validator
            ->scalar('statuscontato')
            ->maxLength('statuscontato', 255)
            ->allowEmpty('statuscontato');

        $validator
            ->scalar('objetivo')
            ->maxLength('objetivo', 255)
            ->allowEmpty('objetivo');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 1000)
            ->allowEmpty('observacao');

        $validator
            ->date('data_contato')
            ->allowEmpty('data_contato');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->dateTime('data_fechamento')
            ->allowEmpty('data_fechamento');

        $validator
            ->date('data_previsaofechamento')
            ->allowEmpty('data_previsaofechamento');

        $validator
            ->scalar('grauinteresse')
            ->maxLength('grauinteresse', 255)
            ->allowEmpty('grauinteresse');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->date('data_lembrete')
            ->allowEmpty('data_lembrete');

        $validator
            ->integer('vendedoridlembrete')
            ->allowEmpty('vendedoridlembrete');

        $validator
            ->integer('lembretevisto')
            ->allowEmpty('lembretevisto');

        $validator
            ->scalar('laudo')
            ->maxLength('laudo', 1000)
            ->allowEmpty('laudo');

        $validator
            ->integer('pessoaidlaudo')
            ->allowEmpty('pessoaidlaudo');

        $validator
            ->dateTime('data_laudo')
            ->allowEmpty('data_laudo');

        $validator
            ->scalar('numeroorcamento')
            ->maxLength('numeroorcamento', 60)
            ->allowEmpty('numeroorcamento');

        $validator
            ->decimal('valororcamento')
            ->allowEmpty('valororcamento');

        $validator
            ->decimal('valorvenda')
            ->allowEmpty('valorvenda');

        $validator
            ->dateTime('data_orcamento')
            ->allowEmpty('data_orcamento');

        $validator
            ->integer('vendedorid')
            ->allowEmpty('vendedorid');

        $validator
            ->integer('idfunil')
            ->allowEmpty('idfunil');

        return $validator;
    }
}
