<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contatoanexo Model
 *
 * @method \App\Model\Entity\Contatoanexo get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contatoanexo newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contatoanexo[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contatoanexo|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contatoanexo patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contatoanexo[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contatoanexo findOrCreate($search, callable $callback = null, $options = [])
 */
class ContatoanexoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contatoanexo');
        $this->setDisplayField('contatoanexoid');
        $this->setPrimaryKey('contatoanexoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contatoanexoid')
            ->allowEmpty('contatoanexoid', 'create');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('caminho')
            ->maxLength('caminho', 500)
            ->allowEmpty('caminho');

        return $validator;
    }
}
