<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contrato Model
 *
 * @method \App\Model\Entity\Contrato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contrato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contrato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contrato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contrato|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contrato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contrato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contrato findOrCreate($search, callable $callback = null, $options = [])
 */
class ContratoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contrato');
        $this->setDisplayField('contratoid');
        $this->setPrimaryKey('contratoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contratoid')
            ->allowEmpty('contratoid', 'create');

        $validator
            ->integer('clienteid')
            ->allowEmpty('clienteid');

        $validator
            ->integer('vendedorid')
            ->allowEmpty('vendedorid');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->scalar('status')
            ->maxLength('status', 50)
            ->allowEmpty('status');

        $validator
            ->scalar('numero')
            ->maxLength('numero', 20)
            ->allowEmpty('numero');

        $validator
            ->date('data')
            ->allowEmpty('data');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->decimal('valoradesao')
            ->allowEmpty('valoradesao');

        $validator
            ->decimal('descontoadesao')
            ->allowEmpty('descontoadesao');

        $validator
            ->decimal('mensalidade')
            ->allowEmpty('mensalidade');

        $validator
            ->scalar('formapagadesao')
            ->maxLength('formapagadesao', 50)
            ->allowEmpty('formapagadesao');

        $validator
            ->scalar('condpagadesao')
            ->maxLength('condpagadesao', 50)
            ->allowEmpty('condpagadesao');

        $validator
            ->integer('produtoid')
            ->allowEmpty('produtoid');

        $validator
            ->integer('vidas')
            ->allowEmpty('vidas');

        $validator
            ->decimal('totalvalor')
            ->allowEmpty('totalvalor');

        $validator
            ->decimal('adesaovendedor')
            ->allowEmpty('adesaovendedor');

        $validator
            ->date('data_adesao')
            ->allowEmpty('data_adesao');

        $validator
            ->date('databonus')
            ->allowEmpty('databonus');

        $validator
            ->decimal('bonusvendedor')
            ->allowEmpty('bonusvendedor');

        $validator
            ->decimal('descontodado')
            ->allowEmpty('descontodado');

        $validator
            ->integer('regraprodutoid')
            ->allowEmpty('regraprodutoid');

        return $validator;
    }
}
