<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contratoadesao Model
 *
 * @method \App\Model\Entity\Contratoadesao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contratoadesao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contratoadesao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contratoadesao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratoadesao|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratoadesao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contratoadesao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contratoadesao findOrCreate($search, callable $callback = null, $options = [])
 */
class ContratoadesaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contratoadesao');
        $this->setDisplayField('contratoadesaoid');
        $this->setPrimaryKey('contratoadesaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contratoadesaoid')
            ->allowEmpty('contratoadesaoid', 'create');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->scalar('formapag')
            ->maxLength('formapag', 50)
            ->allowEmpty('formapag');

        $validator
            ->scalar('condpag')
            ->maxLength('condpag', 50)
            ->allowEmpty('condpag');

        $validator
            ->integer('contratoid')
            ->allowEmpty('contratoid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
