<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contratocomissao Model
 *
 * @method \App\Model\Entity\Contratocomissao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contratocomissao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contratocomissao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contratocomissao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratocomissao|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratocomissao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contratocomissao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contratocomissao findOrCreate($search, callable $callback = null, $options = [])
 */
class ContratocomissaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contratocomissao');
        $this->setDisplayField('contratocomissaoid');
        $this->setPrimaryKey('contratocomissaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contratocomissaoid')
            ->allowEmpty('contratocomissaoid', 'create');

        $validator
            ->integer('contratoid')
            ->allowEmpty('contratoid');

        $validator
            ->decimal('percentualcomissao')
            ->allowEmpty('percentualcomissao');

        $validator
            ->decimal('valorcomissao')
            ->allowEmpty('valorcomissao');

        $validator
            ->decimal('valorparcela')
            ->allowEmpty('valorparcela');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->date('data_pagamento')
            ->allowEmpty('data_pagamento');

        return $validator;
    }
}
