<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contratostatus Model
 *
 * @method \App\Model\Entity\Contratostatus get($primaryKey, $options = [])
 * @method \App\Model\Entity\Contratostatus newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Contratostatus[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contratostatus|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratostatus|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Contratostatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Contratostatus[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contratostatus findOrCreate($search, callable $callback = null, $options = [])
 */
class ContratostatusTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('contratostatus');
        $this->setDisplayField('contratostatusid');
        $this->setPrimaryKey('contratostatusid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contratostatusid')
            ->allowEmpty('contratostatusid', 'create');

        $validator
            ->integer('pessoaid')
            ->requirePresence('pessoaid', 'create')
            ->notEmpty('pessoaid');

        $validator
            ->dateTime('data_mudanca')
            ->requirePresence('data_mudanca', 'create')
            ->notEmpty('data_mudanca');

        $validator
            ->scalar('status')
            ->maxLength('status', 255)
            ->requirePresence('status', 'create')
            ->notEmpty('status');

        $validator
            ->integer('contratoid')
            ->requirePresence('contratoid', 'create')
            ->notEmpty('contratoid');

        return $validator;
    }
}
