<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cota Model
 *
 * @method \App\Model\Entity\Cotum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Cotum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Cotum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cotum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cotum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Cotum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cotum findOrCreate($search, callable $callback = null, $options = [])
 */
class CotaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('cota');
        $this->setDisplayField('idcota');
        $this->setPrimaryKey('idcota');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcota')
            ->allowEmpty('idcota', 'create');

        $validator
            ->integer('idgrupo')
            ->allowEmpty('idgrupo');

        $validator
            ->scalar('valor')
            ->maxLength('valor', 20)
            ->allowEmpty('valor');

        $validator
            ->scalar('unidade')
            ->maxLength('unidade', 20)
            ->allowEmpty('unidade');

        $validator
            ->scalar('data_inicio')
            ->maxLength('data_inicio', 20)
            ->allowEmpty('data_inicio');

        $validator
            ->scalar('data_fim')
            ->maxLength('data_fim', 20)
            ->allowEmpty('data_fim');

        $validator
            ->scalar('ano')
            ->maxLength('ano', 20)
            ->allowEmpty('ano');

        $validator
            ->scalar('mes')
            ->maxLength('mes', 20)
            ->allowEmpty('mes');

        $validator
            ->integer('usuario_criacao')
            ->allowEmpty('usuario_criacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 2000)
            ->allowEmpty('observacao');

        return $validator;
    }
}
