<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cotavenda Model
 *
 * @method \App\Model\Entity\Cotavenda get($primaryKey, $options = [])
 * @method \App\Model\Entity\Cotavenda newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Cotavenda[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cotavenda|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cotavenda patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Cotavenda[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cotavenda findOrCreate($search, callable $callback = null, $options = [])
 */
class CotavendaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('cotavenda');
        $this->setDisplayField('idcotavenda');
        $this->setPrimaryKey('idcotavenda');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idcotavenda')
            ->allowEmpty('idcotavenda', 'create');

        $validator
            ->integer('idcota')
            ->allowEmpty('idcota');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('ano')
            ->allowEmpty('ano');

        $validator
            ->integer('mes')
            ->allowEmpty('mes');

        $validator
            ->scalar('marca')
            ->maxLength('marca', 255)
            ->allowEmpty('marca');

        $validator
            ->integer('idproduto')
            ->allowEmpty('idproduto');

        $validator
            ->scalar('produto')
            ->maxLength('produto', 255)
            ->allowEmpty('produto');

        $validator
            ->scalar('grupoproduto')
            ->maxLength('grupoproduto', 255)
            ->allowEmpty('grupoproduto');

        $validator
            ->integer('idvendedor')
            ->allowEmpty('idvendedor');

        $validator
            ->scalar('vendedor')
            ->maxLength('vendedor', 255)
            ->allowEmpty('vendedor');

        $validator
            ->integer('idrepresentante')
            ->allowEmpty('idrepresentante');

        $validator
            ->scalar('representante')
            ->maxLength('representante', 255)
            ->allowEmpty('representante');

        $validator
            ->integer('idsupervisor')
            ->allowEmpty('idsupervisor');

        $validator
            ->scalar('supervisor')
            ->maxLength('supervisor', 255)
            ->allowEmpty('supervisor');

        $validator
            ->scalar('qtdcota')
            ->maxLength('qtdcota', 20)
            ->allowEmpty('qtdcota');

        $validator
            ->scalar('vlrcota')
            ->maxLength('vlrcota', 20)
            ->allowEmpty('vlrcota');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        return $validator;
    }
}
