<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CreditoUtilizado Model
 *
 * @method \App\Model\Entity\CreditoUtilizado get($primaryKey, $options = [])
 * @method \App\Model\Entity\CreditoUtilizado newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\CreditoUtilizado[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CreditoUtilizado|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CreditoUtilizado patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CreditoUtilizado[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\CreditoUtilizado findOrCreate($search, callable $callback = null, $options = [])
 */
class CreditoUtilizadoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('credito_utilizado');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('idvendedor')
            ->allowEmpty('idvendedor');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('cpf')
            ->maxLength('cpf', 15)
            ->allowEmpty('cpf');

        return $validator;
    }
}
