<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Datetable Model
 *
 * @method \App\Model\Entity\Datetable get($primaryKey, $options = [])
 * @method \App\Model\Entity\Datetable newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Datetable[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Datetable|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Datetable patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Datetable[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Datetable findOrCreate($search, callable $callback = null, $options = [])
 */
class DatetableTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('datetable');
        $this->setDisplayField('datetableid');
        $this->setPrimaryKey('datetableid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('datetableid')
            ->allowEmpty('datetableid', 'create');

        $validator
            ->date('_date')
            ->requirePresence('_date', 'create')
            ->notEmpty('_date');

        return $validator;
    }
}
