<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Demandareprimida Model
 *
 * @method \App\Model\Entity\Demandareprimida get($primaryKey, $options = [])
 * @method \App\Model\Entity\Demandareprimida newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Demandareprimida[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Demandareprimida|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Demandareprimida patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Demandareprimida[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Demandareprimida findOrCreate($search, callable $callback = null, $options = [])
 */
class DemandareprimidaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('demandareprimida');
        $this->setDisplayField('iddemandareprimida');
        $this->setPrimaryKey('iddemandareprimida');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('iddemandareprimida')
            ->allowEmpty('iddemandareprimida', 'create');

        $validator
            ->scalar('clienteid')
            ->maxLength('clienteid', 60)
            ->allowEmpty('clienteid');

        $validator
            ->scalar('cliente')
            ->maxLength('cliente', 255)
            ->allowEmpty('cliente');

        $validator
            ->scalar('codproduto')
            ->maxLength('codproduto', 60)
            ->allowEmpty('codproduto');

        $validator
            ->scalar('produto')
            ->maxLength('produto', 255)
            ->allowEmpty('produto');

        $validator
            ->scalar('fabricante')
            ->maxLength('fabricante', 255)
            ->allowEmpty('fabricante');

        $validator
            ->scalar('grupo')
            ->maxLength('grupo', 255)
            ->allowEmpty('grupo');

        $validator
            ->integer('quantidade')
            ->allowEmpty('quantidade');

        $validator
            ->integer('idpessoacadastro')
            ->allowEmpty('idpessoacadastro');

        $validator
            ->integer('vendedorid')
            ->allowEmpty('vendedorid');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 1000)
            ->allowEmpty('observacao');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
