<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmailAgendamento Model
 *
 * @method \App\Model\Entity\EmailAgendamento get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmailAgendamento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmailAgendamento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmailAgendamento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmailAgendamento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmailAgendamento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmailAgendamento findOrCreate($search, callable $callback = null, $options = [])
 */
class EmailAgendamentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('email_agendamento');
        $this->setDisplayField('agendamentoid');
        $this->setPrimaryKey('agendamentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('agendamentoid')
            ->allowEmpty('agendamentoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 60)
            ->allowEmpty('nome');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 60)
            ->allowEmpty('tipo');

        $validator
            ->integer('templateid')
            ->allowEmpty('templateid');

        $validator
            ->integer('listaid')
            ->allowEmpty('listaid');

        $validator
            ->dateTime('data_disparo')
            ->allowEmpty('data_disparo');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
