<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmailContato Model
 *
 * @method \App\Model\Entity\EmailContato get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmailContato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmailContato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmailContato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmailContato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmailContato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmailContato findOrCreate($search, callable $callback = null, $options = [])
 */
class EmailContatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('email_contato');
        $this->setDisplayField('contatoid');
        $this->setPrimaryKey('contatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid', 'create');

        $validator
            ->scalar('codexterno')
            ->maxLength('codexterno', 30)
            ->allowEmpty('codexterno');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 120)
            ->allowEmpty('nome');

        $validator
            ->scalar('email')
            ->allowEmpty('email');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        return $rules;
    }
}
