<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmailEnvio Model
 *
 * @method \App\Model\Entity\EmailEnvio get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmailEnvio newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmailEnvio[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmailEnvio|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmailEnvio patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmailEnvio[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmailEnvio findOrCreate($search, callable $callback = null, $options = [])
 */
class EmailEnvioTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('email_envio');
        $this->setDisplayField('envioid');
        $this->setPrimaryKey('envioid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('envioid')
            ->allowEmpty('envioid', 'create');

        $validator
            ->integer('agendamentoid')
            ->allowEmpty('agendamentoid');

        $validator
            ->integer('listaid')
            ->allowEmpty('listaid');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->integer('templateid')
            ->allowEmpty('templateid');

        $validator
            ->scalar('status')
            ->maxLength('status', 20)
            ->allowEmpty('status');

        $validator
            ->scalar('assunto')
            ->maxLength('assunto', 255)
            ->allowEmpty('assunto');

        $validator
            ->scalar('corpo')
            ->maxLength('corpo', 8000)
            ->allowEmpty('corpo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->dateTime('data_atualizacao')
            ->requirePresence('data_atualizacao', 'create')
            ->notEmpty('data_atualizacao');

        return $validator;
    }
}
