<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmailLista Model
 *
 * @method \App\Model\Entity\EmailListum get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmailListum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmailListum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmailListum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmailListum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmailListum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmailListum findOrCreate($search, callable $callback = null, $options = [])
 */
class EmailListaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('email_lista');
        $this->setDisplayField('listaid');
        $this->setPrimaryKey('listaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('listaid')
            ->allowEmpty('listaid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 120)
            ->allowEmpty('nome');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
