<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmailListacontato Model
 *
 * @method \App\Model\Entity\EmailListacontato get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmailListacontato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmailListacontato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmailListacontato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmailListacontato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmailListacontato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmailListacontato findOrCreate($search, callable $callback = null, $options = [])
 */
class EmailListacontatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('email_listacontato');
        $this->setDisplayField('listacontatoid');
        $this->setPrimaryKey('listacontatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('listacontatoid')
            ->allowEmpty('listacontatoid', 'create');

        $validator
            ->integer('listaid')
            ->allowEmpty('listaid');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
