<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmpresaCnae Model
 *
 * @method \App\Model\Entity\EmpresaCnae get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmpresaCnae newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmpresaCnae[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCnae|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmpresaCnae patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCnae[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCnae findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaCnaeTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresa_cnae');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('cnae_fiscal')
            ->maxLength('cnae_fiscal', 20)
            ->requirePresence('cnae_fiscal', 'create')
            ->notEmpty('cnae_fiscal');

        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 255)
            ->requirePresence('cnpj', 'create')
            ->notEmpty('cnpj');

        return $validator;
    }
}
