<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmpresaCrm Model
 *
 * @method \App\Model\Entity\EmpresaCrm get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmpresaCrm newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmpresaCrm[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCrm|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmpresaCrm patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCrm[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaCrm findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaCrmTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresa_crm');
        $this->setDisplayField('empresaid');
        $this->setPrimaryKey('empresaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid', 'create');

        $validator
            ->scalar('nomefantasia')
            ->maxLength('nomefantasia', 255)
            ->allowEmpty('nomefantasia');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 255)
            ->allowEmpty('razaosocial');

        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 255)
            ->allowEmpty('cnpj');

        $validator
            ->scalar('endereco')
            ->maxLength('endereco', 500)
            ->allowEmpty('endereco');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 20)
            ->allowEmpty('telefone');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcriacao')
            ->allowEmpty('pessoaidcriacao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));

        return $rules;
    }
}
