<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Empresa Model
 *
 * @method \App\Model\Entity\Empresa get($primaryKey, $options = [])
 * @method \App\Model\Entity\Empresa newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Empresa[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Empresa|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Empresa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Empresa[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Empresa findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresa');
        $this->setDisplayField('idempresa');
        $this->setPrimaryKey('idempresa');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 70)
            ->allowEmpty('nome');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 70)
            ->allowEmpty('razaosocial');

        $validator
            ->scalar('logo')
            ->maxLength('logo', 255)
            ->allowEmpty('logo');

        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 20)
            ->allowEmpty('cnpj');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 70)
            ->allowEmpty('cidade');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 2)
            ->allowEmpty('estado');

        $validator
            ->scalar('erp')
            ->maxLength('erp', 20)
            ->allowEmpty('erp');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('conexao_ip')
            ->maxLength('conexao_ip', 255)
            ->allowEmpty('conexao_ip');

        $validator
            ->scalar('conexao_porta')
            ->maxLength('conexao_porta', 10)
            ->allowEmpty('conexao_porta');

        $validator
            ->scalar('conexao_key')
            ->maxLength('conexao_key', 255)
            ->allowEmpty('conexao_key');

        $validator
            ->scalar('conexao_path')
            ->maxLength('conexao_path', 255)
            ->allowEmpty('conexao_path');

        $validator
            ->scalar('bancoerp')
            ->maxLength('bancoerp', 50)
            ->allowEmpty('bancoerp');

        $validator
            ->scalar('bancoerp_usuario')
            ->maxLength('bancoerp_usuario', 50)
            ->allowEmpty('bancoerp_usuario');

        $validator
            ->scalar('bancoerp_senha')
            ->maxLength('bancoerp_senha', 50)
            ->allowEmpty('bancoerp_senha');

        $validator
            ->scalar('bancoerp_host')
            ->maxLength('bancoerp_host', 255)
            ->allowEmpty('bancoerp_host');

        $validator
            ->scalar('bancoerp_porta')
            ->maxLength('bancoerp_porta', 20)
            ->allowEmpty('bancoerp_porta');

        $validator
            ->scalar('bancoflygestor')
            ->maxLength('bancoflygestor', 50)
            ->allowEmpty('bancoflygestor');

        $validator
            ->scalar('bancoflygestor_usuario')
            ->maxLength('bancoflygestor_usuario', 50)
            ->allowEmpty('bancoflygestor_usuario');

        $validator
            ->scalar('bancoflygestor_senha')
            ->maxLength('bancoflygestor_senha', 50)
            ->allowEmpty('bancoflygestor_senha');

        $validator
            ->scalar('bancoflygestor_porta')
            ->maxLength('bancoflygestor_porta', 20)
            ->allowEmpty('bancoflygestor_porta');

        $validator
            ->scalar('bancoflygestor_host')
            ->maxLength('bancoflygestor_host', 50)
            ->allowEmpty('bancoflygestor_host');

        $validator
            ->scalar('nomehospital')
            ->maxLength('nomehospital', 255)
            ->allowEmpty('nomehospital');

        $validator
            ->integer('hospitalid')
            ->allowEmpty('hospitalid');

        return $validator;
    }
}
